﻿using System;
using System.Windows;
using System.Windows.Controls;

namespace PrintDialog
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private void btn0_Click(object sender, RoutedEventArgs e)
        {
            msd_PrintDialogProcess();
        }

        private void msd_PrintDialogProcess()
        {
            // ラベルの内容を消去します。
            Label01.Content = "";

            // Configure printer dialog box System.Windows.Controlsを設定します。
            System.Windows.Controls.PrintDialog dlg = new System.Windows.Controls.PrintDialog();
            dlg.PageRangeSelection = PageRangeSelection.AllPages;
            dlg.UserPageRangeEnabled = true;

            // Show printer dialog box プリンター・ダイアログボックスを表示します。
            Nullable<bool> result = dlg.ShowDialog();

            // Process printer dialog box results プリンター・ダイアログボックスの結果を処理します。
            if (result == true)
            {
                // ここに印刷処理を記述します。

                // このサンプルコードでは、ラベル表示をするだけです。
                Label01.Content = "印刷ダイアログ完了";
            }
        }
    }
}
